# Generated by Django 3.2.13 on 2022-04-30 01:17

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields
import utils.upload_path


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('ads', '0003_auto_20220423_0512'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Doc',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(max_length=25)),
                ('content', models.TextField(blank=True, null=True)),
                ('slug', models.CharField(max_length=50)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Help',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('username', models.CharField(blank=True, max_length=25, null=True)),
                ('what_i_did', models.TextField(blank=True, max_length=600, null=True)),
                ('what_i_expected_to_happen', models.TextField(blank=True, max_length=600, null=True)),
                ('what_actually_happened', models.TextField(blank=True, max_length=600, null=True)),
                ('anything_else', models.TextField(blank=True, max_length=600, null=True)),
                ('status', models.CharField(choices=[('1', 'Pending'), ('2', 'Open'), ('3', 'Resolved'), ('4', 'Closed')], default='1', max_length=10)),
                ('admin_notes', models.TextField(blank=True, null=True)),
                ('reference_number', models.CharField(blank=True, max_length=20, null=True, unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='News',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('author_image', models.ImageField(blank=True, null=True, upload_to=utils.upload_path.uuid_newsroom)),
                ('author_name', models.CharField(blank=True, max_length=100, null=True)),
                ('publish_date', models.DateField(verbose_name='date published')),
                ('article_title', models.CharField(max_length=250)),
                ('article_content', models.TextField()),
                ('article_image', models.ImageField(blank=True, null=True, upload_to=utils.upload_path.uuid_newsroom)),
                ('tag', models.CharField(blank=True, choices=[('', ''), ('Article', 'Article'), ('Press Release', 'Press Release'), ('External', 'External'), ('Release Notes', 'Release Notes'), ('Guest Post', 'Guest Post')], default='', max_length=50)),
                ('external', models.URLField(blank=True, null=True)),
                ('slug', models.CharField(max_length=250, unique=True)),
            ],
            options={
                'verbose_name_plural': 'News',
            },
        ),
        migrations.CreateModel(
            name='Ads',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('ad_headline', models.CharField(blank=True, max_length=25, null=True)),
                ('ad_link', models.URLField(blank=True, null=True)),
                ('ad_body', models.CharField(blank=True, max_length=150, null=True)),
                ('ad_image', models.ImageField(blank=True, null=True, upload_to=utils.upload_path.uuid_ad, verbose_name='Ad image')),
                ('ad_location', django_countries.fields.CountryField(blank=True, max_length=2, null=True, verbose_name='Ad Location')),
                ('ad_keywords', models.CharField(blank=True, max_length=150, null=True)),
                ('ad_start_date', models.DateField(blank=True, null=True)),
                ('ad_end_date', models.DateField(blank=True, null=True)),
                ('ad_price', models.FloatField(blank=True, null=True)),
                ('payment_method', models.CharField(blank=True, choices=[('Bitcoin', 'Bitcoin')], default='Bitcoin', max_length=20, null=True)),
                ('discount', models.IntegerField(blank=True, null=True)),
                ('amount_due', models.FloatField(blank=True, null=True)),
                ('btc_amount_due', models.FloatField(blank=True, null=True)),
                ('to_bitcoin_address', models.CharField(blank=True, max_length=45, null=True)),
                ('payment_status', models.CharField(blank=True, choices=[('1', 'Paid'), ('2', 'Pending'), ('3', 'Refunded'), ('4', 'Due')], default='2', max_length=10, null=True)),
                ('payment_date', models.DateTimeField(blank=True, null=True)),
                ('status', models.CharField(choices=[('1', 'Approved'), ('2', 'Rejected'), ('3', 'Pending'), ('4', 'Suspended'), ('5', 'Auto-Expired')], default='3', max_length=10)),
                ('notes', models.TextField(blank=True, null=True)),
                ('slug', models.SlugField(blank=True, max_length=20, unique=True)),
                ('send_email', models.BooleanField(blank=True, null=True)),
                ('impressions', models.IntegerField(default=0)),
                ('i_agree', models.BooleanField(default=True, null=True)),
                ('ad_plan', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ads.adspricing')),
                ('clicks', models.ManyToManyField(blank=True, related_name='clicks', to=settings.AUTH_USER_MODEL)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('voucher_code', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ads.vouchers')),
            ],
            options={
                'verbose_name_plural': 'Ads',
            },
        ),
    ]
