# Generated by Django 3.2.9 on 2022-02-08 13:52

from django.db import migrations, models
import django.db.models.deletion
import django_countries.fields
import utils.upload_path


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='AdminNotifications',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('nf_url', models.URLField()),
                ('nf_description', models.CharField(max_length=60)),
                ('nf_title', models.CharField(max_length=30)),
                ('read', models.BooleanField(default=False)),
                ('count', models.PositiveIntegerField(default=1)),
            ],
            options={
                'verbose_name_plural': 'Ads Notifications',
            },
        ),
        migrations.CreateModel(
            name='AdsOwners',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('business_name', models.CharField(blank=True, max_length=100)),
                ('business_location', django_countries.fields.CountryField(blank=True, max_length=2, null=True)),
                ('business_website', models.URLField(blank=True, null=True)),
                ('full_name', models.CharField(blank=True, max_length=50)),
                ('job_title', models.CharField(blank=True, max_length=50, null=True)),
                ('professional_email', models.EmailField(blank=True, max_length=70, null=True)),
                ('notes', models.TextField(blank=True, null=True)),
            ],
            options={
                'verbose_name_plural': 'Ads Owners',
            },
        ),
        migrations.CreateModel(
            name='AdsPricing',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('title', models.CharField(blank=True, max_length=25, null=True)),
                ('type', models.CharField(blank=True, max_length=25, null=True)),
                ('description', models.CharField(blank=True, max_length=150, null=True)),
                ('image', models.ImageField(blank=True, null=True, upload_to=utils.upload_path.uuid_ad)),
                ('price', models.FloatField(blank=True, null=True)),
                ('per', models.CharField(blank=True, help_text='True means ready for sale. False means consumer have to contact the admin.', max_length=50)),
                ('pick', models.BooleanField(blank=True, default=True, null=True)),
            ],
            options={
                'verbose_name_plural': 'Ads Pricing',
            },
        ),
        migrations.CreateModel(
            name='CreateAds',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('headline', models.CharField(blank=True, max_length=25, null=True)),
                ('body', models.CharField(blank=True, max_length=150, null=True)),
                ('location', django_countries.fields.CountryField(blank=True, max_length=2, null=True, verbose_name='Ad Location')),
                ('target_all_users', models.BooleanField(blank=True, null=True)),
                ('link', models.URLField(blank=True, null=True)),
                ('image', models.ImageField(blank=True, default='assets/images/blanks/373x256.png', null=True, upload_to=utils.upload_path.uuid_ad, verbose_name='Ad image')),
                ('start_date', models.DateTimeField(blank=True, null=True, verbose_name='Start Date')),
                ('end_date', models.DateTimeField(blank=True, null=True, verbose_name='End Date')),
                ('ad_id', models.SlugField(blank=True, max_length=20, null=True, unique=True)),
            ],
            options={
                'verbose_name_plural': 'Active Ads',
            },
        ),
        migrations.CreateModel(
            name='Vouchers',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('voucher_code', models.CharField(max_length=5, null=True, unique=True)),
                ('discount_percentage', models.IntegerField(null=True)),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('expired', models.BooleanField(blank=True, null=True)),
                ('plan', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='ads.adspricing')),
            ],
            options={
                'verbose_name_plural': 'Vouchers',
            },
        ),
    ]
